
/* 
 * This file is part of the RTL examples distribution (https://tealsemi.com).
 * Copyright (c) 2022 Franz Steininger.
 * 
 * This program is free software: you can redistribute it and/or modify  
 * it under the terms of the GNU General Public License as published by  
 * the Free Software Foundation, version 3.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

`default_nettype none

module test_must (
  input  wire signed [15:0] a,
  input  wire [14:0] b,  // unsigned positive input to which abs(a) is compared to
  output wire flag    // asserted when abs(a) > b
);

wire signed  [16:0] a_abs;

assign a_abs = a[15] ? -a : $signed({1'b0,a});
assign flag = a_abs[15:0] > {1'b0,b};

endmodule

`default_nettype wire


